/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.NotifyObject;
import ibm.nways.analysis.dpEngine.AbstractResult;
import ibm.nways.analysis.dpEngine.DpInterfaceImpl;
import ibm.nways.analysis.dpEngine.DpNode;
import ibm.nways.analysis.dpEngine.DpPollingDefinition;
import ibm.nways.analysis.dpEngine.DpPollingInstance;
import ibm.nways.analysis.dpEngine.MisMatchRowInfo;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.snmp.AbstractSnmpPoller;
import ibm.nways.jdm.snmp.PollingAction;
import ibm.nways.jdm.snmp.PollingFilter;
import ibm.nways.jdm.snmp.PollingInterval;
import ibm.nways.jdm.snmp.PollingPreFilter;
import ibm.nways.jdm.snmp.SnmpPoller;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.TablePoller;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class MismatchRowNode
extends DpNode {
    private int useThisIndex = -1;
    private String[] normalOIs;
    private int[] normalIndexesInExpression;
    private String[] baseOIs;
    private int[] indexOffsets;
    private int[] indexesInExpression;
    private int numBaseOIs;
    private int numScalarOIs;
    private Object[] oldValueList;
    private Object[] newValueList;
    private PollingInterval pInt;

    protected MismatchRowNode(DpPollingInstance dpPollingInstance, long l, boolean bl) {
        super(dpPollingInstance, l, bl);
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("MisMatchRowNode:Constructor called");
        }
    }

    protected boolean initialize(DpPollingInstance dpPollingInstance, SnmpPoller snmpPoller, TablePoller tablePoller, SnmpSession snmpSession, Hashtable hashtable, NotifyObject notifyObject, DataPoint[] dataPointArray) {
        boolean bl = super.initialize(dpPollingInstance, snmpPoller, tablePoller, snmpSession, hashtable, notifyObject, dataPointArray);
        DpPollingDefinition dpPollingDefinition = this.pollingInst.getPollingDefinition();
        this.pInt = new PollingInterval(dpPollingDefinition.getPollingObjectDefinition().getNotifyObject().getPollingInterval() * 1000);
        String[] stringArray = this.oiList.getScalarOIs();
        int[] nArray = this.oiList.getScalarIndexes();
        this.baseOIs = new String[stringArray.length];
        this.normalOIs = new String[stringArray.length];
        this.indexOffsets = new int[stringArray.length];
        this.indexesInExpression = new int[stringArray.length];
        this.normalIndexesInExpression = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (this.isFunky(stringArray[n])) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], "$");
                this.baseOIs[this.numBaseOIs] = stringTokenizer.nextToken();
                this.indexOffsets[this.numBaseOIs] = Integer.parseInt(stringTokenizer.nextToken());
                this.indexesInExpression[this.numBaseOIs] = nArray[n];
                ++this.numBaseOIs;
            } else {
                this.normalOIs[this.numScalarOIs] = stringArray[n];
                this.normalIndexesInExpression[this.numScalarOIs] = nArray[n];
                ++this.numScalarOIs;
            }
            ++n;
        }
        return bl;
    }

    public void saveScalarValues(Object[] objectArray, Object[] objectArray2) {
        this.oldValueList = objectArray;
        this.newValueList = objectArray2;
    }

    public void setTableValues(int n, Object[] objectArray, Object[] objectArray2) {
        super.setTableValues(n, objectArray, objectArray2);
        MisMatchRowInfo misMatchRowInfo = ((AbstractResult)this.rows.elementAt((int)n)).info;
        int n2 = 0;
        while (n2 < misMatchRowInfo.ois.length) {
            if (this.oldValueList != null) {
                this.oldValues[misMatchRowInfo.indexesInExpression[n2]] = this.oldValueList[misMatchRowInfo.indexesInPoll[n2]];
            }
            if (this.newValueList != null) {
                this.newValues[misMatchRowInfo.indexesInExpression[n2]] = this.newValueList[misMatchRowInfo.indexesInPoll[n2]];
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.numScalarOIs) {
            if (this.oldValueList != null) {
                this.oldValues[this.normalIndexesInExpression[n3]] = this.oldValueList[n3];
            }
            if (this.newValueList != null) {
                this.newValues[this.normalIndexesInExpression[n3]] = this.newValueList[n3];
            }
            ++n3;
        }
    }

    protected Object addRow(String string) {
        AbstractResult abstractResult = (AbstractResult)super.addRow(string);
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("MisMatchRowNode:addRow called " + string);
        }
        String string2 = string.substring(this.baseLength + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
            ++n2;
        }
        this.updateRow(abstractResult, n, nArray, this.indexOffsets, this.indexesInExpression);
        String[] stringArray = this.makeNewOIlist();
        if (stringArray != null) {
            DpPollingDefinition dpPollingDefinition = this.pollingInst.getPollingDefinition();
            if (this.scalarPoller != null) {
                this.session.remove((AbstractSnmpPoller)this.scalarPoller);
            }
            this.scalarPoller = new SnmpPoller(this.pInt, stringArray, true, (PollingAction)dpPollingDefinition, (PollingFilter)dpPollingDefinition, (PollingPreFilter)dpPollingDefinition);
            if (DpInterfaceImpl.trace) {
                DpInterfaceImpl.LogMessage("   MisMatchRowNode:Adding Scalar Poller due to added row:" + this.scalarPoller.toString());
            }
            this.session.add((AbstractSnmpPoller)this.scalarPoller, (Object)this);
        }
        return abstractResult;
    }

    protected Object addRow(OID oID) {
        return this.addRow(oID.toString());
    }

    protected void removeRow(Object object) {
        String[] stringArray;
        super.removeRow(object);
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("MisMatchRowNode:removeRow called " + object.toString());
        }
        if ((stringArray = this.makeNewOIlist()) != null) {
            DpPollingDefinition dpPollingDefinition = this.pollingInst.getPollingDefinition();
            this.session.remove((AbstractSnmpPoller)this.scalarPoller);
            this.scalarPoller = new SnmpPoller(this.pInt, stringArray, true, (PollingAction)dpPollingDefinition, (PollingFilter)dpPollingDefinition, (PollingPreFilter)dpPollingDefinition);
            if (DpInterfaceImpl.trace) {
                DpInterfaceImpl.LogMessage("   MisMatchRowNode:Adding Scalar Poller due to added row:" + this.scalarPoller.toString());
            }
            this.session.add((AbstractSnmpPoller)this.scalarPoller, (Object)this);
        }
    }

    private boolean isFunky(String string) {
        return string.indexOf(36) != -1;
    }

    private void updateRow(AbstractResult abstractResult, int n, int[] nArray, int[] nArray2, int[] nArray3) {
        MisMatchRowInfo misMatchRowInfo;
        abstractResult.info = misMatchRowInfo = new MisMatchRowInfo(n, nArray, nArray2, nArray3, this.numBaseOIs, this.baseOIs);
    }

    private String[] makeNewOIlist() {
        int n;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        while (n3 < this.numScalarOIs) {
            vector.addElement(this.normalOIs[n3]);
            ++n2;
            ++n3;
        }
        int n4 = this.rows.size();
        int n5 = 0;
        while (n5 < n4) {
            MisMatchRowInfo misMatchRowInfo = ((AbstractResult)this.rows.elementAt((int)n5)).info;
            n = 0;
            while (n < this.numBaseOIs) {
                vector.addElement(misMatchRowInfo.ois[n]);
                misMatchRowInfo.indexesInPoll[n] = n2++;
                ++n;
            }
            ++n5;
        }
        String[] stringArray = new String[n2];
        n = 0;
        while (n < n2) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }
}

